Attribute VB_Name = "adt8948"
Option Explicit
'******************************Basic parameters settings ****************************

Declare Function adt8948_initial Lib "adt8948.dll" () As Integer
'*******************functionInitialize motion card***********************
'(1)Return>0,Return value is the quantity of ADT-8948 cards in the system. Value 3 indiates that three cards have been installed and available card numbers are 0, 1 and 2;
'(2)Return=0,Value 0 indicates that no ADT-8948A1 card has been installed
'(3)Return<0,Value -1 indicates that the drivers of ADT-8948A1 card havent been installed
'*******************************************************

Declare Function adt8948_end Lib "adt8948.dll" () As Integer
'***********************release ADT8948A1 card**********************
'Function:Release the resources of motion card
'Return     0:correct            1:wrong
'This function contains the library function that releases the control card; it should be invoked at the end of the program,(only in Windows NT/2000).
'release of ADT8948 source occupied
'*******************************************************

Declare Function set_stop0_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

'*************Set mode of stop0 input signal****************
'Function:Set the valid/invalid and logical electricity of stop0 signal
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    Value 0: invalid 1: valid
'    logic      0:low level stop 1:high level stop
'Return          0:correct           1:wrong
'Default modes:invalidlow level stop
'*******************************************************

Declare Function set_stop1_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'**************Set mode of stop1 input signal*************
'Function:Set the valid/invalid and logical electricity of stop1 signal
'Parameter:
'    cardno      card number
'    axis        axis number(1-4)
'    Value 0: invalid 1: valid
'    logic       0:low level stop    1:high level stop
'Return          0:correct           1:wrong
'Default modes:invalidlow level stop
'******************************************************

Declare Function set_stop2_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'*************Set mode of stop2 input signal**************
'Function:Set the valid/invalid and logical electricity of stop2 signal
'Parameter:
'    cardno      card number
'    axis        axis number(1-4)
'    Value 0: invalid 1: valid
'    logic       0:low level stop    1:high level stop
'Return      0:correct           1:wrong
'Default modes:invalidlow level stop
'STOP2 signal can clear actual position counter when it is valid.
'******************************************************

Declare Function set_actualcount_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal dir As Integer, ByVal freq As Integer) As Integer
'**************set the working mode of actual position counter************
'Function:Set the working mode of actual position counter
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      Pulse input mode
'            0:A/B pulse input   1:Up/Down (PPIN/PMIN) pulse input
'    dir    Counting direction
'    0:  A leads B or PPIN pulse input up count
'                B leads A or PMIN pulse input down count
'    1:      B leads A or PMIN pulse input up count
'                A leads B or PPIN pulse input down count
'    freq    Frequency multiplication of A/B pulse input,Invalid for Up/Down pulse input
'        0: 4     1: 2        2: 1
'Return     0:correct            1:wrong
'Default modes: A/B pulse inputdirection: 0Frequency multiplication: 4

'*******************************************************

Declare Function set_pulse_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer, ByVal dir_logic As Integer) As Integer
'Function:Set working mode of output pulse
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      0: Pulse+Pulse     1:Pulse+Direction
'    logic      0:Positive logical pulse      1:Negative logical pulse
'    dir-logic  0:Positive logic of direction output signal
'                   1:Negativelogic of direction output signal
'Return         0:correct                 1:wrong
'Default modes:Pulse + direction,positive logical pulse,Positive logic of direction output signal.
'******************************************************

Declare Function set_limit_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'Function:Set the mode of positive/negative limit input signal nLMT
'Parameter:
'    cardno          card number
'    axis        axis number(1-4)
'    value       0:sudden stop   1:decelerated stop
'    logic       0:low level valid       1:high level valid
'Return          0:correct               1:wrong
'Default modes:sudden stoplow level valid
'Notice:The limit signal cant be valid or invalid.
'*****************************************************

Declare Function set_softlimit_mode1 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'**************Setting of COMP+ register as software limit*********
'Function:Setting of COMP+ register as software limit
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    Value 0: invalid 1: valid
'Return         0:correct                1:wrong
'Default modes: invalid
'*****************************************************

Declare Function set_softlimit_mode2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'***********Setting of COMP- register as software limit************
'Function:Setting of COMP- register as software limit
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    Value 0: invalid 1: valid
'Return         0:correct                1:wrong
'Default modes: invalid
'*****************************************************

Declare Function set_softlimit_mode3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'*************Comparison objects setting of COMP+/- registers***********
'Function:Comparison objects setting of COMP+/- registers
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      0:Logical position counter   1:Actual position counter
'Return         0:correct                1:wrong
'Default modes:Logical position counter
''*****************************************************


Declare Function disable_soft_limit Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'******************Disable software limit****************
'Function:Disable software limit
'Parameter:
'    cardno       card number
'    axis         axis number
'Return         0:correct                 1:wrong
'***********************************************

Declare Function enable_soft_limit Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'******************Enable software limit****************
'Function:Enable software limit
'Parameter:
'    cardno       card number
'    axis         axis number
'    value        compare objects (0:Logical counter,1:Actual position counter)
'Return       0:correct                 1:wrong
'***************************************************


Declare Function set_inpos_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'****************Setting of servo in-position signal nINPOS***********
'Function:Set the working mode of servo in-position signal nINPOS
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    Value 0: invalid 1: valid
'    logic      0:low level valid        1:high level valid
'Return         0:correct            1:wrong
'Default modes : invalidlow level valid
'*****************************************************

Declare Function set_alarm_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer
'*************Setting of servo alarm signal nALARM*************
'Function:Set the working mode of servo alarm signal nALARM
'Parameter:
'    cardno          card number
'    axis        axis number(1-4)
'    Value 0: invalid 1: valid
'    logic       0:low level valid           1:high level valid
'Return          0:correct               1:wrong
'Default modes : invalidlow level valid
'*****************************************************

Declare Function set_ad_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'**************Acceleration/deceleration setting***************
'Function:Select linear or S-curve acceleration/deceleration.
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      0:linear A/D     1:S-curve A/D
'Return         0:correct        1:wrong
'Default modes: Linear acceleration / deceleration
'*****************************************************

Declare Function set_dec1_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'****************Asymmetric ladder acceleration/deceleration setting***********
'Function:Select symmetric or asymmetric acceleration/deceleration.
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      use in deceleration
'            0:value of acceleration(symmetric)
'            1:value of acceleration(asymmetric)
'Return          0:correct                 1:wrong
'Default modes: symmetric acceleration / deceleration
'*****************************************************

Declare Function set_dec2_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'************Deceleration mode setting of acceleration/deceleration quantitative driving**********
'Function:Set deceleration mode
'Parameter:
'   cardno     card number
'    axis       axis number(1-4)
'    value      0:Automatic deceleration         1:manual deceleration
'Return         0:correct                    1:wrong
'Default modes: Automatic deceleration
'*****************************************************

Declare Function set_circle_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'*************Setting of variable circle function of the counter************
'Function:Set the variable circle mode of counter
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    Value 0: invalid 1: valid
'Return         0:correct                    1:wrong
'Default modes: invalid
'*****************************************************

Declare Function set_input_filter Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal number As Integer, ByVal value As Integer) As Integer
'***************Input signal filtering function setting*************
'Function:Set the filtering function of input signal
'Parameter:
'    cardno      card number
'    axis        axis number(1-4)
'    number      Input types
'1:                LMT ?LMT - ?STOP0?STOP1
'2:                STOP2
'3:                nINPOS?nALARM
'4:                nIN
'                Set the filtering state of the four types input signals above
'    value       0:Filtering invalid        1: Filtering valid
'Return          0:correct          1:wrong
'Default modes: invalid
'********************************************************

Declare Function set_filter_time Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
'*************Constant setting of filtering time of input signals**************
'Function:Set the filtering time constant of input signals
'Parameter:
'    cardno      card number
'    axis        axis number(1-4)
'    value       Maximum noise amplitude reduced(range)   Input signal delay(range)
'Return         0:correct          1:wrong
'*******************************************************

Declare Function set_lock_position Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal regi As Integer, ByVal logical As Integer) As Integer
'********************Set the working mode of position lock*****************
'Function:Set the working mode of position lock,Lock the logical position and actual position of all axis
'Parameter:
'    axisReference axis
'    regiCounter mode  |0:logical counter
'                |1:actual counter
'    logicalLevel signal |0:From high to low
'                  |1: From low to high
'Return         0:correct          1:wrong
'    Note:Use IN signal of specific axis as the trigger signal
'*****************************************************



'******************************************************
'
'*******************Driving status checking********************
'
'******************************************************
Declare Function get_status Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, value As Integer) As Integer
'****************Get the driving status of single axis****************
'Function:Get the driving status of single axis
'Parameter:
'    cardno          card number
'    axis        axis number(1-4)
'    value       Index of driving status
'                0:Driving stopped       Non-0: the value is in 2 bytes
'Return      0:correct                   1:wrong
'*****************************************************

Declare Function get_stopdata Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, value As Integer) As Integer
'**************Get the errors stop data of axes*************
'Function:Get the error stop data of axes
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      Index of error status
'           0:No error         Non-0:the value is in 2 bytes
'Return         0:correct          1:wrong
'*****************************************************

Declare Function get_inp_status Lib "adt8948.dll" (ByVal cardno As Integer, value As Integer) As Integer
'***************et the driving status of interpolation*****************
'Function:Get the driving status of interpolation
'Parameter:
'    cardno      card number
'    value       Index of interpolation status
'            0: Interpolation stopped    1: Interpolating
'Return      0:correct            1:wrong
'*****************************************************

Declare Function get_inp_status2 Lib "adt8948.dll" (ByVal cardno As Integer, value As Integer) As Integer
'***********Get the writable status of continuous interpolation***********
'Function:Get the writable status of continuous interpolation
'Parameter:
'    cardno     card number
'    value      Index of writing status
'0:             Unwritable 1: Writable
'Return     0:correct                        1:wrong
'*****************************************************


Declare Function get_lock_status Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, status As Integer) As Integer
'********************Get lock status*****************
'Function:Get the status of position lock
'Parameter:
'    cardno       card number
'    axis         axis number
'    status       Lock status (0: unlocked, 1: locked)
'Return         0:correct          1:wrong
'Note:This function could tell whether the position lock has been executed
''*****************************************************

Declare Function get_home_status Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, status As Integer, err As Integer) As Integer
'********************Get back-to-home status****************
'Function:Get back-to-home status
'Parameter:
'    cardno      card number
'    axis        axis number
'        status      Whether driving is stopped (0: stopped, 1: moving)
'    err         Whether error occurs (0:Normal, 1: Error)
'Return         0:correct          1:wrong
'**********************************************************

Declare Function get_home_error Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, err As Integer) As Integer
'******************Get back-to-home error*****************
'Function:Get back-to-home error
'Parameter:
'      errError marker
'            0: Normal     >0: Error
'D0:                         comp limit
'D1:                         comp -limit
'D2:                         LMT limit
'D3:                         LMT -limit
'D4:                         Servo alarm
'                        D5: Emergency stop
'                        D6: Z phase signal arrives in advance
'Return         0:correct          1:wrong
''********************************************************

'----------------------------------------------------'
'                  Moving parameter settings                    '
'----------------------------------------------------'

Declare Function set_range Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'******************Range setting*********************
'Function:Range setting
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      R-value range(8000000-16000)
'Return     0:correct                1:wrong
'*****************************************************

Declare Function set_acac Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'****************Set the change rate of acceleration/deceleration************
'Function:Set the change rate of acceleration/deceleration
'Parameter:
'    cardno      card number
'    axis        axis number (1-4)
'    value       K-value range(1-65535)
'Return     0:correct                1:wrong
''*****************************************************

Declare Function set_acc Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'*******************Acceleration setting*******************
'Function:Set the value of acceleration
'Parameter:
'    cardno      card number
'    axis        axis number(1-4)
'    value       A-value range(1-8000)
'Return      0:correct               1:wrong
''*****************************************************

Declare Function set_dec Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'****************Deceleration setting********************
'Function:Set the value of deceleration
'Parameter:
'    cardno      card number
'    axis        axis number(1-4)
'    Value D - Value(1 - 8000)
'Return      0:correct               1:wrong
'*****************************************************

Declare Function set_startv Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'**********************Start velocity setting***************
'Function:Set the value of start velocity
'Parameter:
'    cardno      card number
'    axis        axis number(1-4)
'    Value SV - Value(1 - 8000)
'Return      0:correct               1:wrong
'*****************************************************

Declare Function set_speed Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'*****************Driving speed settin*******************
'Function:Set the value of driving speed
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    Value V - Value(1 - 8000)
'Return     0:correct                1:wrong
'*****************************************************

Declare Function set_command_pos Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'***************Logical position counter setting***************
'Function:Set the value of logical position counter
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      range(-2147483648~+2147483647)
'Return     0:correct                1:wrong
'Notice:You can access the logical position counter in real time
'*****************************************************


Declare Function set_actual_pos Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'*************Actual position counter setting****************
'Function:Set the value of actual position counter
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      range(-2147483648~+2147483647)
'Return     0:correct                1:wrong
'Notice:You can access the actual position counter in real time
'*****************************************************


Declare Function set_comp1 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'******************COMP+ register setting***************
'Function:COMP+ register setting
'Parameter:
'    cardno      card number
'    axis        axis number(1-4)
'    value       range(-2147483648~+2147483647)
'Return     0:correct                1:wrong
'Notice:You can access the COMP+ register in real time
'*****************************************************


Declare Function set_comp2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'******************COMP- register setting***************
'Function:COMP- register setting
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      range(-2147483648~+2147483647)
'Return     0:correct                1:wrong
'Notice:You can access the COMP- register in real time
'*****************************************************


Declare Function set_soft_limit Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value1 As Long, ByVal value2 As Long) As Integer
'*********************Software limit setting******************
'Function:Set the value of software limit
'Parameter:
'    cardno       card number
'    axis         axis number
'    value1       positive limit
'        value2       negative limit
'Return      0:correct              1:wrong
'******************************************************/

Declare Function set_dec_pos Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal value As Long) As Integer
'***************************Set manual deceleration position*************************
'Function:Set the value of COMP+ register
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    value      range(0~268435455)
'Return     0:correct                1:wrong
'If manual deceleration mode is used, you need to set manual deceleration point first
'******************************************************************/



Declare Function set_vector_speed Lib "adt8948.dll" (ByVal cardno As Integer, ByVal mode As Integer) As Integer
'********************Set constant linear speed mode*********************
'Function:Set constant linear speed mode
'Parameter:
'    cardno card number
'    mode0|do not use constant linear speed
'          1| use constant linear speed
'Return         0:correct          1:wrong
'Notice:Linear speed indicates vector speed. Constant linear speed can guarantee the constant combination speed in interpolation
'*****************************************************

Declare Function set_home_mode Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal speed As Long, ByVal logical0 As Integer, ByVal logical1 As Integer, ByVal logical2 As Integer, ByVal offset As Integer, ByVal dir0 As Integer, ByVal dir1 As Integer, ByVal dir2 As Integer, ByVal offsetdir As Integer, ByVal clear As Integer, ByVal pulse As Long) As Integer
'********************Set back-to-home mode*****************
'Function:Set back-to-home mode of appointed axis
'Parameter:
'       logical0stop0|0:low level stop
'                      |1:high level stop
'                      |-1:invalid
'       logical1stop1|0:low level stop
'                      |1:high level stop
'                      |-1:invalid
'       logical2stop2|0:low level stop
'                      |1:high level stop
'                      |-1:invalid
'           0ffset 0|do not offset from home
'                1|offset from home
'       dir0direction|0:positive
'                      |1:negative
'       dir1direction|0:positive
'                      |1:negative
'       dir2direction|0:positive
'                      |1:negative
'       offsetdirOffset direction|0:positive
'                                  |1:negative
'       speedLow speed research(this value should be lower than start velocity of high speed)
'       clearClear counter? (0: Yes, 1: No)
'Return         0:correct          1:wrong
'Note:
'        (1)Back-to-home by 4 step:
'           |step1:hiah-speed near home search stop0((logical0 close home setup);
'           |step2:low-speed home search stop1(logical1 home setup);
'           |step3:low-speed Z-phase search stop2(logical2 encoder Z-phase);
'           |step4:high-speed offset drive(For working origin);
'                (2) The above four steps can decide whether to be carried out by choosing among logical0, logical1logical2 and offset
'        (3)Able to use a proximity switch to act as several signals
''*****************************************************


Declare Function set_symmetry_speed Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*********************Set symmetric acceleration/deceleration*********************
'Function:Set the value of symmetric acceleration/deceleration
'Parameter:
'    cardno       card number
'    axis         axis number
'    lspd         start speed
'        hspd         driving speed
'    tacc         acceleration time
'    vacc         acceleration change rate
'   mode         acceleration mode (0:ladder 1:S-curve)
'Return           0:correct          1:wrong
'********************************************************


Declare Function set_unsymmetry_speed Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*********************Set asymmetric acceleration/deceleration*******************
'Function:Set the value of asymmetric acceleration/deceleration
'Parameter:
'    cardno       card number
'    axis         axis number
'    lspd         start speed
'        hspd         driving speed
'    tacc         acceleration time
'    tdec         deceleration time
'    vacc         acceleration change rate
'    mode         acceleration mode (0:ladder 1:S-curve)
'Return           0:correct          1:wrong
'******************************************************

Declare Function get_command_pos Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, pos As Long) As Integer
'***************Get the logical position of axes**************
'Function:Get the logical position of axes
'Parameter:
'    cardno          card number
'    axis        axis number(1-4)
'    pos     Index of logical position value
'Return     0:correct            1:wrong
'Notice:You can use this function to get the logical position of axes and it can represent the current position of axes if the motor is not out of step
'*****************************************************

Declare Function get_actual_pos Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, pos As Long) As Integer
'****************Get the actual position of axis****************
'Function:Get the actual position of axis
'Parameter:
'    cardno          card number
'    axis        axis number(1-4)
'    pos     Index of actual position value
'Return      0:correct       1:wrong
'Notice:You can use this function to get the actual position of axes and you can get the current position of axes even if the motor is out of step
'*****************************************************


Declare Function get_speed Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, speed As Long) As Integer
'**************Get the current driving speed of axes*************
'Function:Get the current driving speed of axes
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    speed      Index of current driving speed
'Return      0:correct       1:wrong
'*****************************************************

Declare Function get_ad Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ad As Long) As Integer
'*****************Get the current acceleration of axes************
'Function:Get the current acceleration of axes
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    ad     Index of current acceleration
'Return      0:correct       1:wrong
'*****************************************************

Declare Function get_lock_position Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, pos As Long) As Integer
'********************Get lock position*****************
'Function:Get lock position
'Parameter:
'    cardno      card number
'    axis        axis number
'    pos         Locked position
'Return         0:correct          1:wrong
'*****************************************************


Declare Function get_lib_vision Lib "adt8948.dll" (ver As Integer) As Integer
'*******************Library function version checking*******************
'*Function:Get the version of library function
'*Parameter:
'     Version number index (ver is a 4-digit integer with the first two digits are master version number and last two sigits are secondary version number)
'Return         0:correct          1:wrong
'*****************************************************

'----------------------------------------------------'
'                     Basic driving                       '
'----------------------------------------------------'

Declare Function pmove Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long) As Integer
'*******************Quantitative driving*********************
'Function:Single axis quantitative driving
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    pulse      output pulses         range(-268435455~+268435455)
'           >0: Positive      <0: Negative
'Return     0:correct                    1:wrong
''*****************************************************'

Declare Function continue_move Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal dir As Integer) As Integer
'*********************Continuous driving*******************
'Function:Single axis continuous driving
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'    dir    driving direction   0: Positive   1: Negative
'Return        0:correct            1:wrong
''******************************************************

Declare Function dec_stop Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'********************Decelerated stop******************
'Function:Stop current driving process in deceleration
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'Return     0:correct            1:wrong
''******************************************************

Declare Function sudden_stop Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'*******************Sudden stop*******************
'Function:Stop current driving process immediately
'Parameter:
'    cardno     card number
'    axis       axis number(1-4)
'Return     0:correct            1:wrong
'Notice:Stop pulse output immediately in acceleration/deceleration and constant speed driving process.
'***********************************************************


Declare Function stop_axis Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal mode As Integer) As Integer
'**************************Stop single axis************************
'Function:Stop the moving of singl axis in set mode.
'Parameter:
'    cardno       card number
'    axis         axis number
'    mode         stop mode(0:sudden stop 1:decelerated stop)
'Return           0:correct          1:wrong
''**********************************************************

Declare Function stop_all Lib "adt8948.dll" (ByVal cardno As Integer, ByVal mode As Integer) As Integer
'**************************Stop all axes************************
'Function:Stop the moving of all axes of appointed card in set mode.
'Parameter:
'    cardno       card number
'    mode         stop mode(0:sudden stop 1:decelerated stop)
'Return           0:correct          1:wrong
'*********************************************************


Declare Function inp_move2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer
'********************Two axes linear interpolation********************
'Function:Two axes linear interpolation
'Parameter:
'    cardno     card number
'    axis1,axis2     Interpolation axis number         1:X    2:Y  3:Z  4:W
'    pulse1,pulse2   Moving relative distance of axis1,axis2   range(-8388608~+8388607)
'Return     0:correct                  1:wrong
'Notice:The interpolation speed takes the speed of the axis with smaller axis number between axis1 and axis2 as the standard
'**********************************************************

Declare Function inp_cw_arc Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long) As Integer
'*******************CW arc interpolation*****************
'Function:Two axes CW arc interpolation
'Parameter:
'    cardno             card number
'    axis1,axis2    Interpolation axis number         1:X    2:Y  3:Z  4:W
'    x,y        End point position of arc interpolation (relative to start point)       range(-8388608~+8388607)
'    i,j      Circle center position of arc interpolation (relative to start point)             range(-8388608~+8388607)
'Return     0:correct                  1:wrong
'Notice:The interpolation speed takes the speed of axis1
'*********************************************************


Declare Function inp_ccw_arc Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long) As Integer
'*****************CCW arc interpolation*******************
'Function:Two axes CCW arc interpolation
'Parameter:
'    cardno           card number
'    axis1,axis2  Interpolation axis number      1:X    2:Y  3:Z  4:W
'    x,y      End point position of arc interpolation (relative to start point)     range(-8388608~+8388607)
'    i,j        Circle center position of arc interpolation (relative to start point)            range(-8388608~+8388607)
'Return     0:correct                  1:wrong
'Notice:The interpolation speed takes the speed of axis1
''*********************************************************

Declare Function inp_move3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer
'********************Three axes linear interpolation********************
'Function:Three axes linear interpolation
'Parameter:
'    cardno                  card number
'    axis1,axis2,axis3   Interpolation axis number     1:X    2:Y  3:Z  4:W
'    pulse1,pulse2,pulse3    Moving relative distance of X-Y-Z axis
'                                range (-8388608~+8388607)
'    Three axes interpolation,only X-Y-Z axis interpolation
'Return     0:correct                  1:wrong
'Notice:The interpolation speed takes the speed of axis1
''********************************************************


Declare Function inp_dec_enable Lib "adt8948.dll" (ByVal cardno As Integer) As Integer
'********************Enable interpolation deceleration********************
'Function:Enable deceleration of interpolation
'Parameter:
'    cardno     card number
'Return         0:correct          1:wrong
''********************************************************

Declare Function inp_dec_disable Lib "adt8948.dll" (ByVal cardno As Integer) As Integer
'********************Disable interpolation deceleration*********************
'Function:Disable deceleration of interpolation
'Parameter:
'    cardno     card number
'Return      0:correct                    1:wrong
'*********************************************************

Declare Function manual_pmove Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long) As Integer
'********************Manual quantitative driving*****************
'Function:Quantitative driving of external signals
'Parameter:
'    cardno      card number
'    axis        axis number
'    pulse pulse
'Return         0:correct          1:wrong
'Note:(1) Send out fixed pulse, but the drive does not start immediately until the level of external signal changes
'(2) Ordinary button and handwheel are acceptable
'*********************************************************

Declare Function manual_continue Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'********************Manual continuous driving*****************
'Function:Continuous driving of external signals
'Parameter:
'    cardno     card number
'    axis       axis number
'Return         0:correct          1:wrong
'Note: (1) Send out fixed pulse, but the drive does not start immediately until the level of external signal changes
'(2) Ordinary button and handwheel are acceptable
'********************************************************

Declare Function manual_disable Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'********************Disable manual driving*****************
'Function:Disable manual driving function
'Parameter:
'    cardno      card number
'    axis        axis number
'Return         0:correct          1:wrong
'*********************************************************


Declare Function inp_step_command2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer
'********************Command type two axes stepping interpolation*****************
'Function:Set the data of two axes command stepping interpolation.
'Parameter:
'    the same as 2-axis interpolation
'Return         0:correct          1:wrong
'Note:Send out data of stepping interpolation, the drive does not start but waiting for drive command function
'**********************************************************

Declare Function inp_step_command3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer
'********************Command type three axes stepping interpolation*****************
'Function:Set the data of three axes command stepping interpolation.
'Parameter:
'    the same as 3-axis interpolation
'Return         0:correct          1:wrong
'Note:Send out data of stepping interpolation, the drive does not start but waiting for drive command function
'**********************************************************

Declare Function inp_step_move Lib "adt8948.dll" (ByVal cardno As Integer) As Integer
'********************Command stepping interpolation driving******************
'Function:Execute command stepping interpolation in single step
'Parameter:
'    cardno      card number
'Return         0:correct          1:wrong
'Note:Drive the stepping motion in the form of command according to the parameter of the set function
'*********************************************************

Declare Function inp_step_signal2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer
'********************Signal type two axes stepping interpolation*****************
'Function:Set the data of two axes signal type stepping interpolation.
'Parameter:
'    the same as 2-axis interpolation
'Return         0:correct          1:wrong
'Note:Send out data of stepping interpolation, the drive does not work but waiting for the external signal level to drop to low level
'**********************************************************

Declare Function inp_step_signal3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer
'********************Signal type three axes stepping interpolation*****************
'Function:Set the data of three axes stepping interpolation.
'Parameter:
'    the same as 3-axis interpolation
'Return         0:correct          1:wrong
'Note:Send out data of stepping interpolation, the drive does not work but waiting for the external signal level to drop to low level
'**********************************************************

Declare Function inp_step_stop Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'**********************Stop stepping interpolation*******************
'Function:Stop executing stepping interpolation.
'Parameter:
'    cardno      card number
'    axis        axis number
'Return         0:correct          1:wrong
'
'Notice: Axis that is in the state of stepping interpolation must carry out the stop command of stepping interpolation before going to other drives
'**********************************************************

Declare Function home Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'*************************Automatic back-to-home***********************
'Function:Appointed axis executes back-to-home motion automatically.
'Parameter:
'    cardno      card number
'    axis        axis number
'Return         0:correct          1:wrong
''***********************************************************


Declare Function clear_home_error Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer) As Integer
'********************Clear back-to-home error*****************
'Function:Clear back-to-home error
'Parameter:
'    cardno      card number
'    axis        axis number
'Return         0:correct          1:wrong
'***********************************************************


Declare Function set_in_move1 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal axis1 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal logical As Integer, ByVal mode As Integer) As Integer
'***********************Signal type single axis follow moving setting********************
'Function:setting synchronous move function
'Parameter:
'        axisactive axis
'        axis1driven axis
'        pulseActive axis pulses
'        pulse1Driven axis1 pulses
'        logicalElectricity level logic|0:from high to low
'                            |1:from low to high
'        modeRunning status of active axis0|persistent
'                           1|appointed pulse
'Return         0:correct          1:wrong
'Note:Use the IN signal of active axis as trigger signal
'**********************************************************

Declare Function set_in_move2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal logical As Integer, ByVal mode As Integer) As Integer
'*********************Signal type 2 axes follow moving setting******************
'Function: Set the IN synchronization action
'Parameter:
'        axisactive axis
'        axis1driven axis
'        axis2driven axis
'        pulse1pulse
'        pulse2pulse
'        logicalLevel signal|0:From high to low
'                     |1:From low to high
'        modeThe active axis has moved? 0| Yes
'                         1| No
'Return         0:correct          1:wrong
'Note:Use the IN signal of active axis as trigger signal
''**********************************************************
Declare Function set_in_move3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal logical As Integer, ByVal mode As Integer) As Integer
'*********************Signal type 3 axes follow moving setting*******************
'Function:Set the IN synchronization action
'Parameter:
'        axisactive axis
'        axis1driven axis1
'        axis2driven axis2
'        axis3driven axis3
'        pulsedrive pulse of active axis
'        pulse1drive pulse of driven axis1
'        pulse2drive pulse of driven axis2
'        pulse3drive pulse of driven axis3
'        logicalLevel signal|0:From high to low
'                     |1:From low to high
'        modeThe active axis has moved? 0| Yes
'                         1| No
'Return         0:correct          1:wrong
'Note:Use the IN signal of active axis as trigger signal
'*********************************************************

Declare Function set_in_stop1 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal axis1 As Integer, ByVal logical As Integer, ByVal mode As Integer) As Integer
'*********************Single axis follow stopping setting function********************
'Function:Set the IN synchronization action
'Parameter:
'        axisactive axis
'        axis1driven axis1
'        logicalLevel signal|0:From high to low
'                     |1:From low to high
'                modeactive axis stop?|0:yes
'                              1|:no
'Return         0:correct          1:wrong
'Note:Signal changes detected, driven axis has stopped and the driving status of active axis can be set
'************************************************************

Declare Function set_in_stop2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal logical As Integer, ByVal mode As Integer) As Integer
'*********************2-axis follow stopping setting function*********************
'Function:Set the IN synchronization action
'Parameter:
'        axisactive axis
'        axis1driven axis1
'        axis2driven axis2
'        logicalLevel signal|0:From high to low
'                     |1:From low to high
'                modeactive axis stop?|0:yes
'                              1|:no
'Return         0:correct          1:wrong
'Note:Signal changes detected, driven axis has stopped and the driving status of active axis can be set
'*********************************************************

Declare Function set_in_stop3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal logical As Integer, ByVal mode As Integer) As Integer
'*********************3-axis follow stopping setting function*********************
'Function:Set the IN synchronization action
'Parameter:
'        axisactive axis
'        logicalLevel signal|0:From high to low
'                     |1:From low to high
'                modeactive axis stop?|0:yes
'                              1|:no
'Return         0:correct          1:wrong
'Note:Signal changes detected, driven axis has stopped and the driving status of active axis can be set
'**********************************************************

Declare Function set_comp_pmove1 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal axis1 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal regi As Integer, ByVal term As Integer) As Integer
'*******************Setting of single-axis drive when arriving at the target position****************
'Function:Setting of single-axis drive when arriving at the target position
'Parameter:
'        axisactive axis
'        axis1driven axis
'        pulseActive axis pulses
'        pulse1drive pulse of driven axis1
'                regi0|comp+  Select the compare register
'                      1|comp-
'                term0|>=  Select the compare register
'                      1|<
'Return         0:correct          1:wrong
'**********************************************************

Declare Function set_comp_pmove2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal regi As Integer, ByVal term As Integer) As Integer
'*******************Setting of 2-axis drive when arriving at the target position*****************
'Function:Setting of 2-axis drive when arriving at the target position
'Parameter:
'        axisactive axis
'        axis1driven axis1
'        axis2driven axis2
'        pulsetarget position of active axis
'        pulse1drive pulse of driven axis1
'        pulse2drive pulse of driven axis2
'        regi0|comp+  Select the compare register
'                      1|comp-
'                term0|>=  Select the compare register
'                      1|<
'Return         0:correct          1:wrong
'*********************************************************

Declare Function set_comp_pmove3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse As Long, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal regi As Integer, ByVal term As Integer) As Integer
'*******************Setting of 3-axis drive when arriving at the target position*****************
'Function:Setting of 3-axis drive when arriving at the target position
'Parameter:
'        axisactive axis
'        axis1driven axis1
'        axis2driven axis2
'        axis2driven axis3
'        pulsetarget position of active axis
'        pulse1drive pulse of driven axis1
'        pulse2drive pulse of driven axis2
'        pulse3drive pulse of driven axis3
'        regi0|comp+  Select the compare register
'                      1|comp-
'                term0|>=  Select the compare register
'                      1|<
'Return         0:correct          1:wrong
'********************************************************

Declare Function set_comp_stop1 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal axis1 As Integer, ByVal pulse As Long, ByVal regi As Integer, ByVal term As Integer, ByVal mode As Integer) As Integer
'********************Setting of stopping drive when arriving at the target position*****************
'Function:Setting of stopping drive when arriving at the target position
'Parameter:
'        axisactive axis
'        axis1driven axis1
'        pulsetarget position of active axis
'        regi0|comp+  Select the compare register
'                      1|comp-
'                term0|>=  Select the compare register
'                      1|<
'                modeactive axis stop?|0:yes
'                              1|:no
'
'Return         0:correct          1:wrong
'********************************************************

Declare Function set_comp_stop2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse As Long, ByVal regi As Integer, ByVal term As Integer, ByVal mode As Integer) As Integer
'********************Setting of stopping drive when arriving at the target position*****************
'Function:Setting of stopping drive when arriving at the target position
'Parameter:
'        axisactive axis
'        axis1driven axis1
'        axis2driven axis2
'        pulsetarget position of active axis
'        regi0|comp+  Select the compare register
'                      1|comp-
'                term0|>=  Select the compare register
'                      1|<
'                modeactive axis stop?|0:yes
'                              1|:no
'Return         0:correct          1:wrong
'*********************************************************

Declare Function set_comp_stop3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long, ByVal regi As Integer, ByVal term As Integer, ByVal mode As Integer) As Integer
'*******************Setting of stopping drive when arriving at the target position****************
'Function:Setting of stopping drive when arriving at the target position
'Parameter:
'        axisactive axis
'        pulsetarget position of active axis
'        regi0|comp+  Select the compare register
'                      1|comp-
'                term0|>=  Select the compare register
'                      1|<
'                modeactive axis stop?|0:yes
'                              1|:no
'Return         0:correct          1:wrong
'*********************************************************


'----------------------------------------------------'
'                      Composite drives                      '
'Note:The following functions are added for the convenience of customers          '
'----------------------------------------------------'
Declare Function symmetry_relative_move Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'***********************Symmetrical relative movement of single-axis******************
'Function: Refer to the current position and perform quantitative movement in the symmetrical acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis---axis number
'      pulse --pulse
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
''********************************************************

Declare Function symmetry_absolute_move Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*********************Symmetrical absolute movement of single-axis*******************
'Function:Refer to the position of zero point and perform quantitative movement in the symmetrical acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis---axis number
'      pulse --pulse
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
'********************************************************


Declare Function unsymmetry_relative_move Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'********************asymmetrical relative movement of single-axis********************
'Function:Refer to the current position and perform quantitative movement in the asymmetrical acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis---axis number
'      pulse --pulse
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      tdec---time of deceleration (Unit: sec)
'      vacc---change rate of acceleration/deceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
'********************************************************


Declare Function unsymmetry_absolute_move Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*********************asymmetrical absolute movement of single-axis*******************
'Function:Refer to the position of zero point and perform quantitative movement in the asymmetrical acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis---axis number
'      pulse --pulse
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      tdec---time of deceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
'********************************************************


Declare Function symmetry_relative_line2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'Function:Refer to the position of zero point and perform linear interpolation in symmetrical acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      pulse1 --pulse1
'      pulse2 --pulse2
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
''********************************************************

Declare Function symmetry_absolute_line2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*****************Two axes symmetric linear interpolation absolute moving*****************
'Function:Refer to the position of zero point and perform linear interpolation in symmetrical acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      pulse1 --pulse1
'      pulse2 --pulse2
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
''*********************************************************

Declare Function unsymmetry_relative_line2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*****************Two axes asymmetric linear interpolation relative moving***************
'Function:Refer to current position and perform linear interpolation in asymmetric acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      pulse1 --pulse1
'      pulse2 --pulse2
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'     tdec---time of deceleration (Unit: sec)
'      vacc---change rate of acceleration/deceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
'*********************************************************


Declare Function unsymmetry_absolute_line2 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'****************Two axes asymmetric linear interpolation absolute moving****************
'Function:Refer to the position of zero point and perform linear interpolation in asymmetric acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      pulse1 --pulse1
'      pulse2 --pulse2
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      tdec---time of deceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
'*******************************************************


Declare Function symmetry_relative_line3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'****************Three axes symmetric linear interpolation relative moving****************
'Function:Refer to current position and perform linear interpolation in symmetric acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      axis3---axis number3
'      pulse1 --pulse1
'      pulse2 --pulse2
'      pulse3 --pulse3
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))'
'Return         0:correct          1:wrong
'*******************************************************


Declare Function symmetry_absolute_line3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*****************Three axes symmetric linear interpolation absolute moving***************
'Function:Refer to the position of zero point and perform linear interpolation in symmetric acceleration/deceleration.
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      axis3---axis number3
'      pulse1 --pulse1
'      pulse2 --pulse2
'      pulse3 --pulse3
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
'********************************************************


Declare Function unsymmetry_relative_line3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*****************Three axes asymmetric linear interpolation relative moving****************
'Function:Refer to current position and perform linear interpolation in asymmetric acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      axis3---axis number3
'      pulse1 --pulse1
'      pulse2 --pulse2
'      pulse3 --pulse3
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      tdec---time of deceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
'********************************************************




Declare Function unsymmetry_absolute_line3 Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*****************Three axes asymmetric linear interpolation absolute moving****************
'Function:Refer to the position of zero point and perform linear interpolation in asymmetric acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      axis3---axis number3
'      pulse1 --pulse1
'      pulse2 --pulse2
'      pulse3 --pulse3
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      tdec---time of deceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'********************************************************




Declare Function symmetry_relative_arc Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long, ByVal dir As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*****************Two axes symmetric arc interpolation relative moving****************
'Function:Refer to current position and perform arc interpolation in symmetric acceleration/deceleration.
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      xy----Coordinates of arc end point (Refer to current point, that is, starting point of arc)
'      ij----Centre coordinate (Refer to current point, that is, starting point of arc)
'      dir-----Moving direction (0-Clockwise,1-Anti-clockwise)
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
''********************************************************



Declare Function symmetry_absolute_arc Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long, ByVal dir As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'******************Two axes symmetric arc interpolation absolute moving*****************
'Function:Refer to the position of zero point and perform arc interpolation in symmetric acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      xy----Coordinates of arc end point (Refer to current point, that is, starting point of arc)
'      ij----Centre coordinate (Refer to current point, that is, starting point of arc)
'      dir-----Moving direction (0-Clockwise,1-Anti-clockwise)
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
''*********************************************************
'


Declare Function unsymmetry_relative_arc Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long, ByVal dir As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*****************Two axes asymmetric arc interpolation relative moving****************
'Function: Refer to current position and perform arc interpolation in asymmetric acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      xy----Coordinates of arc end point (Refer to current point, that is, starting point of arc)
'      ij----Centre coordinate (Refer to current point, that is, starting point of arc)
'      dir-----Moving direction (0-Clockwise,1-Anti-clockwise)
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)
'      tdec---time of deceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
''******************************************************

Declare Function unsymmetry_absolute_arc Lib "adt8948.dll" (ByVal cardno As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Long, ByVal Y As Long, ByVal i As Long, ByVal j As Long, ByVal dir As Integer, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal tdec As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer
'*****************Two axes asymmetric arc interpolation absolute moving****************
'Function:Refer to position of zero point and perform arc interpolation in asymmetric acceleration/deceleration
'Parameter:
'          cardno-card number
'      axis1---axis number1
'      axis2---axis number2
'      xy----Coordinates of arc end point (Refer to current point, that is, starting point of arc)
'      ij----Centre coordinate (Refer to current point, that is, starting point of arc)
'      dir-----Moving direction (0-Clockwise,1-Anti-clockwise)
'      lspd---low speed
'      hspd---high speed
'          tacc---time of acceleration (Unit: sec)'
'      tdec---time of deceleration (Unit: sec)
'      vacc---change rate of acceleration
'      mode ---mode(trapezoid(0) Or S - curve(1))
'Return         0:correct          1:wrong
'********************************************************


Declare Function read_bit Lib "adt8948.dll" (ByVal cardno As Integer, ByVal number As Integer) As Integer
'******************Read single input bit**********************
'Function:Get the status of single input bit
'Parameter:
'    cardno     card number
'    number     Input bit (0-34)
'Return         0:low level         1:high level        -1:wrong
''*******************************************************

Declare Function write_bit Lib "adt8948.dll" (ByVal cardno As Integer, ByVal number As Integer, ByVal value As Integer) As Integer
'**********************Output single bit*********************
'Function:Corresponding port performs output operation.
'Parameter:
'    cardno     card number
'    number     Output bit(0-31)
'    Value 0: low 1: high
'Return         0:correct                1:wrong
''*******************************************************


Declare Function get_out Lib "adt8948.dll" (ByVal cardno As Integer, ByVal number As Integer) As Integer
'***********************Get the status of output*********************
'Parameter:
'    cardno       card number
'    number       port number
'Return:current status of appointed port,-1 indicates that parameter wrong
''******************************************************




Public Sub MyProc()

    DoEvents

End Sub

